define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var JST = window.JST;
	var _ = window._;

	return View.extend({
		template: JST['assets/tpl/client/finished.html'],
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {
			var stats = this.game.getMeUser().get('stats');

			this.$el.html(this.template({
				game: this.game,
				stats: stats
			}));

			return this;
		}
	});
});